int numWaves = 7; //<>//
float[] amplitudes = new float[numWaves];
float[] frequencies = new float[numWaves];
float[] speeds = new float[numWaves];

// Time control
float t = 0;
boolean manualMode = false;
float timeStep = 0.1;

// Point tracking
float trackedX = 400;  // X position to track (middle of screen)
ArrayList<PVector> trail = new ArrayList<PVector>();  // Trail of past positions
int maxTrailLength = 200;

void setup() {
  size(800, 600);
  
  for (int i = 0; i < numWaves; i++) {
    amplitudes[i] = random(10, 40);
    frequencies[i] = random(0.005, 0.03);
    speeds[i] = -4; // negative = wave moves right
  }
}

void draw() {
  background(255);
  
  // Auto-advance time
  if (!manualMode) {
    t += timeStep * 0.1; 
  }
  
  // Draw UI Text
  fill(50);
  textSize(14);
  textAlign(LEFT, TOP);
  text("Mode: " + (manualMode ? "MANUAL" : "AUTO"), 20, 20);
  text("Tracked X: " + int(trackedX), 20, 38);
  text("'m' toggle mode | LEFT/RIGHT arrows to move tracked point", 20, 56);
  if (manualMode) text("UP arrow to step time", 20, 74);

  translate(0, height/2);
  
  // Draw wave
  noFill();
  stroke(0, 150);
  strokeWeight(2);
  
  beginShape();
  for (int x = 0; x <= width; x += 2) {
    float y = getWaveY(x);
    vertex(x, y);
  }
  endShape();

  // Get current tracked point position
  float trackedY = getWaveY(trackedX);
  
  // Add to trail
  trail.add(new PVector(trackedX, trackedY));
  if (trail.size() > maxTrailLength) {
    trail.remove(0);
  }
  
  // Draw vertical line at tracked X
  stroke(200, 200, 255);
  strokeWeight(1);
  line(trackedX, -height/2, trackedX, height/2);
  
  // Draw trail (fading)
  noFill();
  strokeWeight(2);
  for (int i = 1; i < trail.size(); i++) {
    PVector prev = trail.get(i - 1);
    PVector curr = trail.get(i);
    
    // Fade based on age
    float alpha = map(i, 0, trail.size(), 50, 255);
    stroke(255, 100, 100, alpha);
    line(prev.x, prev.y, curr.x, curr.y);
  }
  
  // Draw current tracked point
  fill(255, 50, 50);
  stroke(100, 0, 0);
  strokeWeight(2);
  ellipse(trackedX, trackedY, 16, 16);
  
  // Draw Y position indicator on right side
  stroke(255, 100, 100);
  strokeWeight(1);
  line(width - 30, trackedY, width, trackedY);
  fill(50);
  textAlign(RIGHT, CENTER);
  textSize(12);
  text(nf(trackedY, 0, 1), width - 35, trackedY);
}

// Get wave height at x position
float getWaveY(float x) {
  float y = 0;
  for (int i = 0; i < numWaves; i++) {
    y += sin(x * frequencies[i] + t * speeds[i]) * amplitudes[i];
  }
  return y;
}

void keyPressed() {
  if (key == 'm' || key == 'M') {
    manualMode = !manualMode;
  }
  
  if (manualMode && keyCode == UP) {
    t += timeStep;
  }
  
  // Move tracked point with arrow keys
  if (keyCode == LEFT) {
    trackedX = max(0, trackedX - 20);
    trail.clear();  // Clear trail when moving
  }
  if (keyCode == RIGHT) {
    trackedX = min(width, trackedX + 20);
    trail.clear();  // Clear trail when moving
  }
}
