﻿
using System;
using Unity.Mathematics;
using UnityEngine;

namespace StylizedWater3
{ 
public class SinglePointWaterVisualizer : MonoBehaviour
{
    public HeightQuerySystem.Interface heightInterface = new HeightQuerySystem.Interface();

    private HeightQuerySystem.Sampler sampler;
    private HeightQuerySystem.AsyncRequest request;

    private float sampledHeight;


    public Color SphereColor =  Color.cyan;
    public float SphereRadius = .1f;

    private void OnEnable()
    {
        // Create sampler with ONE sample point
        sampler = new HeightQuerySystem.Sampler();
        sampler.SetSampleCount(1);

        if (heightInterface.method == HeightQuerySystem.Interface.Method.GPU)
        {
            request = new HeightQuerySystem.AsyncRequest(
                GetHashCode(),
                sampler,
                name
            );

            request.invalidateMisses = true;
            request.onCompleted += OnHeightReturned;
            request.Issue();
        }
    }

    private void OnDisable()
    {
        if (request != null)
        {
            request.onCompleted -= OnHeightReturned;
            request.Dispose();
            request = null;
        }

        if (sampler != null)
        {
            sampler.Dispose();
            sampler = null;
        }
    }

    private void FixedUpdate()
    {
        UpdateSamplePosition();

        if (heightInterface.method == HeightQuerySystem.Interface.Method.CPU)
        {
            heightInterface.GetWaterObject(transform.position);
            if (heightInterface.HasMissingReferences()) return;

            Gerstner.ComputeHeight(sampler, heightInterface);
            ApplyHeight(sampler.heightValues[0]);
        }
    }

    private void OnHeightReturned()
    {
        ApplyHeight(sampler.heightValues[0]);
    }

    private void UpdateSamplePosition()
    {
        Vector3 pos = transform.position;
        sampler.SetSamplePosition(0, pos);
    }

    private void ApplyHeight(float h)
    {
        if (HeightQuerySystem.EqualsVoid(h)) return;

        sampledHeight = h;

        Vector3 pos = transform.position;
        pos.y = sampledHeight;
        transform.position = pos;
    }

    private void OnDrawGizmos()
    {
        Gizmos.color = SphereColor;
        Gizmos.DrawSphere(transform.position, SphereRadius);
    }
}
}