color WATER_FILL_COLOR = color(100, 160, 255);
color WATER_STROKE_COLOR = color(50, 100, 200);


void renderSingleWave(Canvas canvas, WaveData wave)
{
  fill(WATER_FILL_COLOR); 
  stroke(WATER_STROKE_COLOR); 
  
  beginShape();
  vertex(canvas.bottomLeft().x, canvas.bottomLeft().y);
  
  int sampleCount = wave.samples.length;
  
  for (int i = 0; i < sampleCount; i++) {
    float xNorm = i / (float)(sampleCount - 1);
    float y = wave.samples[i];
    
    float panelX = canvas.x + xNorm * canvas.w;
    float panelY = canvas.y + canvas.halfHeight() + y * canvas.halfHeight();
    
    vertex(panelX, panelY);
  }

  vertex(canvas.bottomRight().x, canvas.bottomRight().y);
  endShape();
}


void renderCumulativeWaves(Canvas canvas, Sim sim)
{ 
  fill(WATER_FILL_COLOR); 
  stroke(WATER_STROKE_COLOR); 

  beginShape();
  vertex(canvas.bottomLeft().x, canvas.bottomLeft().y);
  
  for (int i = 0; i < sim.sampleCount; i++) {
    float xNorm = i / (float)(sim.sampleCount - 1);
    float y = sim.getCachedSampleAveraged(i);
    
    float panelX = canvas.x + xNorm * canvas.w;
    float panelY = canvas.y + canvas.halfHeight() + y * canvas.halfHeight();
    
    vertex(panelX, panelY);
  }

  vertex(canvas.bottomRight().x, canvas.bottomRight().y);
  endShape();
}
