int WINDOW_WIDTH = 1280;
int WINDOW_HEIGHT = 720;
Canvas WAVE_CANVAS;
int GLOBAL_WAVE_SAMPLES = 100;
Sim WAVE_SIM;

Spring1D TEST_SPRING;
Spring1D TEST_SPRING_2;

void setup() {
  size(1280, 720); 
  
  // processing can't use the const in size for whatever reason... 
  if (width != WINDOW_WIDTH) println("ERR: Your window width is different than the const WINDOW_WIDTH");
  if (height != WINDOW_HEIGHT) println("ERR: Your window height is different than the const WINDOW_HEIGHT");
  
  WAVE_CANVAS = new Canvas(0, 300, WINDOW_WIDTH, WINDOW_HEIGHT - 300); 
   
  WaveData[] waves = new WaveData[] {
    new WaveData(1.0, 1.0, 1.0),
    new WaveData(2.0, 0.3, 0.6),
    new WaveData(0.7, 0.78, 2.0),
    new WaveData(0.9, 0.4, 0.5) 
  };
  
  WAVE_SIM = new Sim(waves, GLOBAL_WAVE_SAMPLES);
  
  TEST_SPRING = new Spring1D(width * .5, 50, 2.5, 1);
  TEST_SPRING_2 = new Spring1D(width * .5, 50, 2.5, 1);
}

float previousTime = 0.0;

void draw() {
  background(255); // clear with white
  
  float elapsed = millis() / 1000.0;
  WAVE_SIM.sim(elapsed);
  renderCumulativeWaves(WAVE_CANVAS, WAVE_SIM);
  
  float dt = elapsed - previousTime;
  previousTime = elapsed;
  
  float screenX = 100;
  float xNorm = WAVE_CANVAS.normFromX(screenX);
  float wavesY = WAVE_SIM.getCachedAtAveraged(xNorm);
  float screenY = wavesY * WAVE_CANVAS.halfHeight() + WAVE_CANVAS.center().y;
  
  TEST_SPRING.setRestingPosition(screenY, false);
  TEST_SPRING.sim(dt);
  TEST_SPRING.debugDraw(WAVE_CANVAS.xFromNorm(xNorm), Axis.Y, true, false);
  
  screenX = 700;
  xNorm = WAVE_CANVAS.normFromX(screenX);
  wavesY = WAVE_SIM.getCachedAtAveraged(xNorm);
  screenY = wavesY * WAVE_CANVAS.halfHeight() + WAVE_CANVAS.center().y;
  
  TEST_SPRING_2.setRestingPosition(screenY, false);
  TEST_SPRING_2.sim(dt);
  TEST_SPRING_2.debugDraw(WAVE_CANVAS.xFromNorm(xNorm), Axis.Y, true, false);
}
