/* Used to determine the rect where to draw */
class Canvas
{
  boolean ERR_IF_OFFSCREEN = false;
  
  float x;
  float y;
  float w;
  float h;
  
  Canvas(float x, float y, float w, float h)
  {
    this.x = x;
    this.y = y;
    this.w = w;
    this.h = h;
    
    if (this.x + this.w > width && ERR_IF_OFFSCREEN) println("ERROR: panel will go off screen with these parameters!");
    if (this.y + this.h > height && ERR_IF_OFFSCREEN) println("ERROR: panel will go off-screen with these parameters!");
  }
  
  public float xFromNorm(float norm) { 
    return x + w * norm;
  }
  
  public float yFromNorm(float norm) {
    return y + h * norm; 
  }
  
  public float normFromX(float x) {
    return (x - this.x) / this.w; 
  }
  
  public float normFromY(float y) {
    return (y - this.y) / this.h; 
  }
  
  public float halfWidth() {
    return w * .5; 
  }
  
  public float halfHeight() {
    return h * .5;  
  }
  
  public PVector topLeft() {
     return new PVector(x, y); 
  }
  
  public PVector topRight() {
    return new PVector(x + w, y); 
  }
  
  public PVector bottomLeft() {
    return new PVector(x, y + h);
  }
  
  public PVector bottomRight() {
    return new PVector(x + w, y + h);
  }
  
  public PVector middleLeft() {
    return new PVector(x, y + halfHeight());
  }
  
  public PVector middleRight() {
    return new PVector(x + w, y + halfHeight());
  }
  
  public PVector centerTop() {
    return new PVector(x + halfWidth(), y);
  }
  
  public PVector centerBottom() {
    return new PVector(x + halfWidth(), y + h);
  }
  
  public PVector center() {
    return new PVector(x + halfWidth(), y + halfHeight()); 
  }
}
